#include <iostream>

#include <getopt.h>

#include <devcoons-streaming.h>

	void usage()
	{
		printf("Usage : -i <ip_address> -p <port> -f <format> -w <width> -h <height> -s <source>\n");
	}

	int main(int argc, char * argv[])
	{
		int opt = 0, long_index = 0;

		static struct option long_options[] = 
		{
			{"ip_address",  required_argument,  0,  'i' },	
			{"port",   		required_argument,  0,  'p' },				
			{"format",   	required_argument,  0,  'f' },			
			{"width",   	required_argument,  0,  'w' },			
			{"height",   	required_argument,  0,  'h' },								
			{"source",   	required_argument,  0,  's' },			
			{0,				0,					0,	0   }
		};

		char * ip_address = NULL, * source = NULL;

		int port = -1, format = -1, width = -1, height = -1; 

		while ( (opt = getopt_long(argc, argv, "i:p:f:w:h:s:", long_options, &long_index )) != -1 ) 

			switch (opt) 
			{
				case 'i':
				
					ip_address = (char *)malloc(20);
				
					strcpy(ip_address,optarg);
					
					break;
					
				case 'p' :
				
					port = atoi(optarg);
					
					break;
				
				case 'f':
				
					format = atoi(optarg);
				
					break;
					
				case 'w':
				
					width = atoi(optarg);

					break;
					
				case 'h':
				
					height = atoi(optarg);
				
					break;
					
				case 's':
				
					source = (char*)malloc(256);
				
					strcpy(source,optarg);
				
					break;
					
				default:
				
					usage();
					
					exit(EXIT_FAILURE);
			}

		printf("devcoons Video Streamer is starting\n");
	
		if (source == NULL || port == -1)
		{
			printf(" - FATAL ERROR - Missing required argumets (port , video source)\n ");
			
			usage();
					
			exit(EXIT_FAILURE);
		}
		
		if(ip_address == NULL)
		{
			printf(" - Warning: IP Address not specified. Defalt value: localhost\n");
			
			fflush(stdout);
			
			ip_address = (char *)malloc(20);
				
			strcpy(ip_address,"127.0.0.1");
		}
		
		if(width == -1)
		{
			printf(" - Warning: Output image width not specified. Defalt value: 400\n");
			
			fflush(stdout);
			
			width = 400;
		}

		if(height == -1)
		{
			printf(" - Warning: Output image height not specified. Defalt value: 272\n");
			
			fflush(stdout);
			
			height = 272;
		}
		
		if(format == -1)
		{
			printf(" - Warning: Output image format not specified. Defalt value: 32BMP\n");
			
			fflush(stdout);
			
			format = 0;
		}		
		
		printf(" [Completed] Settings: IP %s, Port %d, Format %d, Width %d, Height %d, Source %s\n",ip_address, port, format, width, height, source);
		
		switch(devcoonsStreaming::Initialize(ip_address, port, format, width, height, source))
		{
			case -2:
			
				printf(" [Error] (Code: -2)] ");
				
				exit(EXIT_FAILURE);
				
				break;
				
			case -1:
			
				printf(" [Error (Code: -1)] ");
				
				exit(EXIT_FAILURE);
				
				break;
			default:
				printf(" [Completed] ");
		}
		
		printf("Initialize streaming library\n");
		
		
		
		devcoonsStreaming::StartStreaming();

		printf(" [Completed] Start streaming service threads\n");


		printf(" [Completed] Start video to frames delay for buffering\n");
		
			fflush(stdout);
			
			usleep(3000000);
	
		printf(" [Completed] Start Runtime Details\n [ ");
			
		for(int i=0;i<124;i++)
			
			printf(" ");
			
	
		
		for ( ;; )		
		{
			for(int i=0;i<124;i++) printf("\b");
			
			printf("| ] Message Delay: %5d, Packet Delay: %5d, Frame Rate: %2d, Data Sended: %4dMb, Buffer: %.4d/%.4d, Buffering Threads: %2d",1,1,1,1,devcoonsStreaming::BufferElements(),STREAM_BUFFER_SIZE,devcoonsStreaming::BufferingThreads());
			
			fflush(stdout);  usleep(200000);
			
			for(int i=0;i<124;i++) printf("\b");
			
			printf("/ ] Message Delay: %5d, Packet Delay: %5d, Frame Rate: %2d, Data Sended: %4dMb, Buffer: %.4d/%.4d, Buffering Threads: %2d",1,1,1,1,devcoonsStreaming::BufferElements(),STREAM_BUFFER_SIZE,devcoonsStreaming::BufferingThreads());
			
			fflush(stdout);  usleep(200000);
			
			for(int i=0;i<124;i++) printf("\b");
			
			printf("- ] Message Delay: %5d, Packet Delay: %5d, Frame Rate: %2d, Data Sended: %4dMb, Buffer: %.4d/%.4d, Buffering Threads: %2d",1,1,1,1,devcoonsStreaming::BufferElements(),STREAM_BUFFER_SIZE,devcoonsStreaming::BufferingThreads());
			
			fflush(stdout);	usleep(200000);
			
			for(int i=0;i<124;i++) printf("\b");
			
			printf("\\ ] Message Delay: %5d, Packet Delay: %5d, Frame Rate: %2d, Data Sended: %4dMb, Buffer: %.4d/%.4d, Buffering Threads: %2d",1,1,1,1,devcoonsStreaming::BufferElements(),STREAM_BUFFER_SIZE,devcoonsStreaming::BufferingThreads());
			
			fflush(stdout); usleep(200000);	

fflush(stdout);			
		}
		
		return 0;
	}
